/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitcurex;

import java.io.IOException;
import java.util.Arrays;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.bitcurex.BitcurexExchange;
import org.knowm.xchange.bitcurex.service.BitcurexMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitcurexTradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitcurex = ExchangeFactory.INSTANCE.createExchange(BitcurexExchange.class.getName());
        BitcurexTradesDemo.requestData(bitcurex, CurrencyPair.BTC_EUR);
        BitcurexTradesDemo.requestData(bitcurex, CurrencyPair.BTC_PLN);
    }

    private static void requestData(Exchange bitcurex, CurrencyPair pair) throws IOException {
        MarketDataService marketDataService = bitcurex.getMarketDataService();
        BitcurexTradesDemo.generic(marketDataService, pair);
        BitcurexTradesDemo.raw((BitcurexMarketDataServiceRaw)marketDataService, pair.counter.getCurrencyCode());
    }

    private static void generic(MarketDataService marketDataService, CurrencyPair pair) throws IOException {
        Trades trades = marketDataService.getTrades(pair, new Object[0]);
        System.out.println("Trades, Size= " + trades.getTrades().size());
        System.out.println(trades.toString());
    }

    private static void raw(BitcurexMarketDataServiceRaw marketDataService, String currency) throws IOException {
        Object[] trades = marketDataService.getBitcurexTrades(currency);
        System.out.println("Trades, default. Size= " + trades.length);
        System.out.println(Arrays.toString(trades));
    }
}

