/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitfinex.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.bitfinex.v1.BitfinexExchange;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexDepth;
import org.knowm.xchange.bitfinex.v1.service.BitfinexMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitfinexDepthDemo {
    public static void main(String[] args) throws Exception {
        Exchange btce = ExchangeFactory.INSTANCE.createExchange(BitfinexExchange.class.getName());
        MarketDataService marketDataService = btce.getMarketDataService();
        BitfinexDepthDemo.generic(marketDataService);
        BitfinexDepthDemo.raw((BitfinexMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[]{10000, 10000});
        System.out.println("Current Order Book size for BTC / USD: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println(orderBook.toString());
    }

    private static void raw(BitfinexMarketDataServiceRaw marketDataService) throws IOException {
        BitfinexDepth bitfinexDepth = marketDataService.getBitfinexOrderBook("btcusd", Integer.valueOf(50), Integer.valueOf(50));
        System.out.println("Current Order Book size for BTC / USD: " + (bitfinexDepth.getAsks().length + bitfinexDepth.getBids().length));
        System.out.println("First Ask: " + bitfinexDepth.getAsks()[0].toString());
        System.out.println("First Bid: " + bitfinexDepth.getBids()[0].toString());
        System.out.println(bitfinexDepth.toString());
    }
}

