/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitfinex.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.bitfinex.v1.BitfinexExchange;
import org.knowm.xchange.bitfinex.v1.dto.marketdata.BitfinexTicker;
import org.knowm.xchange.bitfinex.v1.service.BitfinexMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class TickerDemo {
    public static void main(String[] args) throws Exception {
        Exchange bitfinex = ExchangeFactory.INSTANCE.createExchange(BitfinexExchange.class.getName());
        MarketDataService marketDataService = bitfinex.getMarketDataService();
        TickerDemo.generic(marketDataService);
        TickerDemo.raw((BitfinexMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        Ticker ticker = marketDataService.getTicker(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(ticker.toString());
    }

    private static void raw(BitfinexMarketDataServiceRaw marketDataService) throws IOException {
        BitfinexTicker ticker = marketDataService.getBitfinexTicker("btcusd");
        System.out.println(ticker.toString());
    }
}

