/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitfinex.marketdata;

import java.io.IOException;
import java.util.Arrays;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.bitfinex.v1.BitfinexExchange;
import org.knowm.xchange.bitfinex.v1.service.BitfinexMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class TradesDemo {
    public static void main(String[] args) throws Exception {
        Exchange bitfinex = ExchangeFactory.INSTANCE.createExchange(BitfinexExchange.class.getName());
        MarketDataService marketDataService = bitfinex.getMarketDataService();
        TradesDemo.generic(marketDataService);
        TradesDemo.raw((BitfinexMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("Trades, Size= " + trades.getTrades().size());
        System.out.println(trades.toString());
    }

    private static void raw(BitfinexMarketDataServiceRaw marketDataService) throws IOException {
        Object[] trades = marketDataService.getBitfinexTrades("btcusd", System.currentTimeMillis() / 1000L - 120L);
        System.out.println("Trades, default. Size= " + trades.length);
        System.out.println(Arrays.toString(trades));
    }
}

