/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitso.account;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitso.dto.account.BitsoBalance;
import org.knowm.xchange.bitso.dto.account.BitsoDepositAddress;
import org.knowm.xchange.bitso.service.BitsoAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.examples.bitso.BitsoDemoUtils;
import org.knowm.xchange.service.account.AccountService;

public class BitsoAccountDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitso = BitsoDemoUtils.createExchange();
        AccountService accountService = bitso.getAccountService();
        BitsoAccountDemo.generic(accountService);
        BitsoAccountDemo.raw((BitsoAccountServiceRaw)accountService);
    }

    private static void generic(AccountService accountService) throws IOException {
        AccountInfo wallet = accountService.getAccountInfo();
        System.out.println("Wallet as String: " + wallet.toString());
        String depositAddress = accountService.requestDepositAddress(Currency.BTC, new String[0]);
        System.out.println("Deposit address: " + depositAddress);
        String withdrawResult = accountService.withdrawFunds(Currency.BTC, new BigDecimal(1).movePointLeft(4), "XXX");
        System.out.println("withdrawResult = " + withdrawResult);
    }

    private static void raw(BitsoAccountServiceRaw accountService) throws IOException {
        BitsoBalance bitsoBalance = accountService.getBitsoBalance();
        System.out.println("Bitso balance: " + bitsoBalance);
        BitsoDepositAddress depositAddress = accountService.getBitsoBitcoinDepositAddress();
        System.out.println("Bitcoin deposit address: " + depositAddress);
        String withdrawResult = accountService.withdrawBitsoFunds(new BigDecimal(1).movePointLeft(4), "XXX");
        System.out.println("Bitso withdrawal response = " + withdrawResult);
    }
}

