/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitso.marketdata;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.bitso.BitsoExchange;
import org.knowm.xchange.bitso.dto.marketdata.BitsoOrderBook;
import org.knowm.xchange.bitso.dto.marketdata.BitsoTicker;
import org.knowm.xchange.bitso.service.BitsoMarketDataServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitsoMarketDataDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitso = ExchangeFactory.INSTANCE.createExchange(BitsoExchange.class.getName());
        MarketDataService marketDataService = bitso.getMarketDataService();
        BitsoMarketDataDemo.generic(marketDataService);
        BitsoMarketDataDemo.raw((BitsoMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        CurrencyPair cp = new CurrencyPair(Currency.BTC, Currency.MXN);
        Ticker ticker = marketDataService.getTicker(cp, new Object[0]);
        System.out.println("Ticker: " + ticker);
        OrderBook orderBook = marketDataService.getOrderBook(cp, new Object[0]);
        System.out.println("Current Order Book size for BTC / MXN: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("Last Ask: " + ((LimitOrder)orderBook.getAsks().get(orderBook.getAsks().size() - 1)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println("Last Bid: " + ((LimitOrder)orderBook.getBids().get(orderBook.getBids().size() - 1)).toString());
        System.out.println(orderBook.toString());
        Object[] args = new Object[]{"hour"};
        List trades = marketDataService.getTrades(cp, args).getTrades();
        System.out.println("Number Trades within last hour: " + trades.size());
        for (Trade t : trades) {
            System.out.println("     " + t);
        }
    }

    private static void raw(BitsoMarketDataServiceRaw marketDataService) throws IOException {
        BitsoTicker ticker = marketDataService.getBitsoTicker(CurrencyPair.BTC_MXN);
        System.out.println("Ticker: " + ticker);
        BitsoOrderBook orderBook = marketDataService.getBitsoOrderBook(CurrencyPair.BTC_MXN);
        System.out.println("Current Order Book size for BTC / MXN: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((List)orderBook.getAsks().get(0)).toString());
        System.out.println("First Bid: " + ((List)orderBook.getBids().get(0)).toString());
        System.out.println(orderBook.toString());
    }
}

