/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitso.trade;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitso.dto.trade.BitsoOrder;
import org.knowm.xchange.bitso.service.BitsoTradeServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.examples.bitso.BitsoDemoUtils;
import org.knowm.xchange.service.trade.TradeService;

public class BitsoTradeDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitso = BitsoDemoUtils.createExchange();
        TradeService tradeService = bitso.getTradeService();
        BitsoTradeDemo.generic(tradeService);
        BitsoTradeDemo.raw((BitsoTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws IOException {
        BitsoTradeDemo.printOpenOrders(tradeService);
        LimitOrder limitOrder = new LimitOrder(Order.OrderType.ASK, new BigDecimal("0.01"), new CurrencyPair(Currency.BTC, Currency.MXN), "", null, new BigDecimal("5000.00"));
        String limitOrderReturnValue = tradeService.placeLimitOrder(limitOrder);
        System.out.println("Limit Order return value: " + limitOrderReturnValue);
        BitsoTradeDemo.printOpenOrders(tradeService);
        boolean cancelResult = tradeService.cancelOrder(limitOrderReturnValue);
        System.out.println("Canceling returned " + cancelResult);
        BitsoTradeDemo.printOpenOrders(tradeService);
    }

    private static void printOpenOrders(TradeService tradeService) throws IOException {
        OpenOrders openOrders = tradeService.getOpenOrders();
        System.out.println("Open Orders: " + openOrders.toString());
    }

    private static void raw(BitsoTradeServiceRaw tradeService) throws IOException {
        BitsoTradeDemo.printRawOpenOrders(tradeService);
        BitsoOrder order = tradeService.sellBitsoOrder(new BigDecimal("0.01"), new BigDecimal("5000.00"));
        System.out.println("BitsoOrder return value: " + order);
        BitsoTradeDemo.printRawOpenOrders(tradeService);
        boolean cancelResult = tradeService.cancelBitsoOrder(order.getId());
        System.out.println("Canceling returned " + cancelResult);
        BitsoTradeDemo.printRawOpenOrders(tradeService);
    }

    private static void printRawOpenOrders(BitsoTradeServiceRaw tradeService) throws IOException {
        BitsoOrder[] openOrders = tradeService.getBitsoOpenOrders();
        System.out.println("Open Orders: " + openOrders.length);
        for (BitsoOrder order : openOrders) {
            System.out.println(order.toString());
        }
    }
}

