/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitso.trade;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitso.dto.trade.BitsoUserTransaction;
import org.knowm.xchange.bitso.service.BitsoTradeServiceRaw;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.examples.bitso.BitsoDemoUtils;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.DefaultTradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;

public class BitsoUserTradeHistoryDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitso = BitsoDemoUtils.createExchange();
        TradeService tradeService = bitso.getTradeService();
        BitsoUserTradeHistoryDemo.generic(tradeService);
        BitsoUserTradeHistoryDemo.raw((BitsoTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws IOException {
        UserTrades trades = tradeService.getTradeHistory(tradeService.createTradeHistoryParams());
        System.out.println(trades);
        UserTrades tradesLimitedTo17 = tradeService.getTradeHistory((TradeHistoryParams)new DefaultTradeHistoryParamPaging(Integer.valueOf(17)));
        System.out.println(tradesLimitedTo17);
    }

    private static void raw(BitsoTradeServiceRaw tradeService) throws IOException {
        BitsoUserTransaction[] tradesLimitedTo17;
        BitsoUserTransaction[] trades;
        for (BitsoUserTransaction trade : trades = tradeService.getBitsoUserTransactions(Long.valueOf(1000L))) {
            System.out.println(trade);
        }
        for (BitsoUserTransaction trade : tradesLimitedTo17 = tradeService.getBitsoUserTransactions(Long.valueOf(17L))) {
            System.out.println(trade);
        }
    }
}

