/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitstamp.account;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitstamp.dto.account.BitstampBalance;
import org.knowm.xchange.bitstamp.dto.account.BitstampDepositAddress;
import org.knowm.xchange.bitstamp.dto.account.BitstampWithdrawal;
import org.knowm.xchange.bitstamp.dto.account.WithdrawalRequest;
import org.knowm.xchange.bitstamp.service.BitstampAccountServiceRaw;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.examples.bitstamp.BitstampDemoUtils;
import org.knowm.xchange.service.account.AccountService;

public class BitstampAccountDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitstamp = BitstampDemoUtils.createExchange();
        AccountService accountService = bitstamp.getAccountService();
        BitstampAccountDemo.generic(accountService);
        BitstampAccountDemo.raw((BitstampAccountServiceRaw)accountService);
    }

    private static void generic(AccountService accountService) throws IOException {
        AccountInfo accountInfo = accountService.getAccountInfo();
        System.out.println("AccountInfo as String: " + accountInfo.toString());
        String depositAddress = accountService.requestDepositAddress(Currency.BTC, new String[0]);
        System.out.println("Deposit address: " + depositAddress);
        String withdrawResult = accountService.withdrawFunds(Currency.BTC, new BigDecimal(1).movePointLeft(4), "XXX");
        System.out.println("withdrawResult = " + withdrawResult);
    }

    private static void raw(BitstampAccountServiceRaw accountService) throws IOException {
        BitstampBalance bitstampBalance = accountService.getBitstampBalance();
        System.out.println("BitstampBalance: " + bitstampBalance);
        BitstampDepositAddress depositAddress = accountService.getBitstampBitcoinDepositAddress();
        System.out.println("BitstampDepositAddress address: " + depositAddress);
        List unconfirmedDeposits = accountService.getUnconfirmedDeposits();
        System.out.println("Unconfirmed deposits:");
        for (Object unconfirmedDeposit : unconfirmedDeposits) {
            System.out.println(unconfirmedDeposit);
        }
        List withdrawalRequests = accountService.getWithdrawalRequests();
        System.out.println("Withdrawal requests:");
        for (WithdrawalRequest unconfirmedDeposit : withdrawalRequests) {
            System.out.println(unconfirmedDeposit);
        }
        BitstampWithdrawal withdrawResult = accountService.withdrawBtcFunds(new BigDecimal(1).movePointLeft(4), "XXX");
        System.out.println("BitstampBooleanResponse = " + withdrawResult);
    }
}

