/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitstamp.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.bitstamp.BitstampExchange;
import org.knowm.xchange.bitstamp.dto.marketdata.BitstampTicker;
import org.knowm.xchange.bitstamp.service.BitstampMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BitstampTickerDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitstamp = ExchangeFactory.INSTANCE.createExchange(BitstampExchange.class.getName());
        MarketDataService marketDataService = bitstamp.getMarketDataService();
        BitstampTickerDemo.generic(marketDataService);
        BitstampTickerDemo.raw((BitstampMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        Ticker ticker = marketDataService.getTicker(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(ticker.toString());
    }

    private static void raw(BitstampMarketDataServiceRaw marketDataService) throws IOException {
        BitstampTicker bitstampTicker = marketDataService.getBitstampTicker(CurrencyPair.BTC_USD);
        System.out.println(bitstampTicker.toString());
    }
}

