/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitstamp.marketdata;

import java.io.IOException;
import java.util.Arrays;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.bitstamp.BitstampExchange;
import org.knowm.xchange.bitstamp.service.BitstampMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class TradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitstamp = ExchangeFactory.INSTANCE.createExchange(BitstampExchange.class.getName());
        MarketDataService marketDataService = bitstamp.getMarketDataService();
        TradesDemo.generic(marketDataService);
        TradesDemo.raw((BitstampMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("Trades, default. Size= " + trades.getTrades().size());
        trades = marketDataService.getTrades(CurrencyPair.BTC_USD, new Object[]{BitstampMarketDataServiceRaw.BitstampTime.HOUR});
        System.out.println("Trades, hour= " + trades.getTrades().size());
        trades = marketDataService.getTrades(CurrencyPair.BTC_USD, new Object[]{BitstampMarketDataServiceRaw.BitstampTime.MINUTE});
        System.out.println("Trades, minute= " + trades.getTrades().size());
        System.out.println(trades.toString());
    }

    private static void raw(BitstampMarketDataServiceRaw marketDataService) throws IOException {
        Object[] trades = marketDataService.getTransactions(CurrencyPair.BTC_USD, null);
        System.out.println("Trades, default. Size= " + trades.length);
        trades = marketDataService.getTransactions(CurrencyPair.BTC_USD, BitstampMarketDataServiceRaw.BitstampTime.HOUR);
        System.out.println("Trades, hour= " + trades.length);
        trades = marketDataService.getTransactions(CurrencyPair.BTC_USD, BitstampMarketDataServiceRaw.BitstampTime.MINUTE);
        System.out.println("Trades, minute= " + trades.length);
        System.out.println(Arrays.toString(trades));
    }
}

