/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitstamp.trade;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitstamp.BitstampAuthenticatedV2;
import org.knowm.xchange.bitstamp.dto.trade.BitstampOrder;
import org.knowm.xchange.bitstamp.service.BitstampTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.examples.bitstamp.BitstampDemoUtils;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class BitstampTradeDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitstamp = BitstampDemoUtils.createExchange();
        TradeService tradeService = bitstamp.getTradeService();
        BitstampTradeDemo.generic(tradeService);
        BitstampTradeDemo.raw((BitstampTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws IOException {
        OpenOrdersParamCurrencyPair openOrdersParamsBtcEur = (OpenOrdersParamCurrencyPair)tradeService.createOpenOrdersParams();
        openOrdersParamsBtcEur.setCurrencyPair(CurrencyPair.BTC_EUR);
        OpenOrdersParamCurrencyPair openOrdersParamsBtcUsd = (OpenOrdersParamCurrencyPair)tradeService.createOpenOrdersParams();
        openOrdersParamsBtcUsd.setCurrencyPair(CurrencyPair.BTC_USD);
        OpenOrdersParams openOrdersParamsAll = tradeService.createOpenOrdersParams();
        BitstampTradeDemo.printOpenOrders(tradeService, openOrdersParamsAll);
        LimitOrder limitOrder = new LimitOrder(Order.OrderType.BID, new BigDecimal(".01"), CurrencyPair.BTC_EUR, null, null, new BigDecimal("500.00"));
        String limitOrderReturnValue = tradeService.placeLimitOrder(limitOrder);
        System.out.println("Limit Order return value: " + limitOrderReturnValue);
        BitstampTradeDemo.printOpenOrders(tradeService, openOrdersParamsAll);
        BitstampTradeDemo.printOpenOrders(tradeService, (OpenOrdersParams)openOrdersParamsBtcEur);
        BitstampTradeDemo.printOpenOrders(tradeService, (OpenOrdersParams)openOrdersParamsBtcUsd);
        boolean cancelResult = tradeService.cancelOrder(limitOrderReturnValue);
        System.out.println("Canceling returned " + cancelResult);
        BitstampTradeDemo.printOpenOrders(tradeService, openOrdersParamsAll);
    }

    private static void printOpenOrders(TradeService tradeService, OpenOrdersParams openOrdersParams) throws IOException {
        OpenOrders openOrders = tradeService.getOpenOrders(openOrdersParams);
        System.out.printf("Open Orders for %s: %s%n", openOrdersParams, openOrders);
    }

    private static void raw(BitstampTradeServiceRaw tradeService) throws IOException {
        BitstampTradeDemo.printRawOpenOrders(tradeService);
        BitstampOrder order = tradeService.placeBitstampOrder(CurrencyPair.BTC_USD, BitstampAuthenticatedV2.Side.sell, new BigDecimal(".001"), new BigDecimal("1000.00"));
        System.out.println("BitstampOrder return value: " + order);
        BitstampTradeDemo.printRawOpenOrders(tradeService);
        boolean cancelResult = tradeService.cancelBitstampOrder(order.getId());
        System.out.println("Canceling returned " + cancelResult);
        BitstampTradeDemo.printRawOpenOrders(tradeService);
    }

    private static void printRawOpenOrders(BitstampTradeServiceRaw tradeService) throws IOException {
        BitstampOrder[] openOrders = tradeService.getBitstampOpenOrders(CurrencyPair.BTC_USD);
        System.out.println("Open Orders: " + openOrders.length);
        for (BitstampOrder order : openOrders) {
            System.out.println(order.toString());
        }
    }
}

