/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bitstamp.trade;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.bitstamp.dto.trade.BitstampUserTransaction;
import org.knowm.xchange.bitstamp.service.BitstampTradeHistoryParams;
import org.knowm.xchange.bitstamp.service.BitstampTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.examples.bitstamp.BitstampDemoUtils;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;

public class BitstampUserTradeHistoryDemo {
    public static void main(String[] args) throws IOException {
        Exchange bitstamp = BitstampDemoUtils.createExchange();
        TradeService tradeService = bitstamp.getTradeService();
        BitstampUserTradeHistoryDemo.generic(tradeService);
        BitstampUserTradeHistoryDemo.raw((BitstampTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws IOException {
        UserTrades trades = tradeService.getTradeHistory(tradeService.createTradeHistoryParams());
        System.out.println(trades);
        BitstampTradeHistoryParams params = (BitstampTradeHistoryParams)tradeService.createTradeHistoryParams();
        params.setPageLength(Integer.valueOf(17));
        params.setCurrencyPair(CurrencyPair.BTC_USD);
        UserTrades tradesLimitedTo17 = tradeService.getTradeHistory((TradeHistoryParams)params);
        System.out.println(tradesLimitedTo17);
    }

    private static void raw(BitstampTradeServiceRaw tradeService) throws IOException {
        BitstampUserTransaction[] tradesLimitedTo17;
        for (BitstampUserTransaction trade : tradesLimitedTo17 = tradeService.getBitstampUserTransactions(Long.valueOf(17L), CurrencyPair.BTC_USD)) {
            System.out.println(trade);
        }
    }
}

