/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.bleutrade.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.bleutrade.BleutradeExchange;
import org.knowm.xchange.bleutrade.service.BleutradeMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class BleutradeMarketDataDemo {
    private static CurrencyPair currencyPair = CurrencyPair.LTC_BTC;

    public static void main(String[] args) throws IOException, InterruptedException {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(BleutradeExchange.class.getName());
        Exchange bleutrade = ExchangeFactory.INSTANCE.createExchange(exchangeSpecification);
        MarketDataService dataService = bleutrade.getMarketDataService();
        BleutradeMarketDataDemo.generic(dataService);
        BleutradeMarketDataDemo.raw((BleutradeMarketDataServiceRaw)dataService);
    }

    private static void generic(MarketDataService dataService) throws IOException, InterruptedException {
        System.out.println(dataService.getTicker(currencyPair, new Object[0]));
        Thread.sleep(1000L);
        System.out.println(dataService.getOrderBook(currencyPair, new Object[]{50}));
        Thread.sleep(1000L);
        System.out.println(dataService.getTrades(currencyPair, new Object[]{100}));
        Thread.sleep(1000L);
    }

    private static void raw(BleutradeMarketDataServiceRaw dataService) throws IOException, InterruptedException {
        System.out.println(dataService.getBleutradeTicker(currencyPair));
        Thread.sleep(1000L);
        System.out.println(dataService.getBleutradeOrderBook(currencyPair, 50));
        Thread.sleep(1000L);
        System.out.println(dataService.getBleutradeMarketHistory(currencyPair, 100));
    }
}

