/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.btcmarkets;

import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.btcmarkets.service.BTCMarketsTradeService;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.examples.btcmarkets.BTCMarketsExampleUtils;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class BTCMarketsTradeDemo {
    public static void main(String[] args) throws Exception {
        Exchange btcMarketsExchange = BTCMarketsExampleUtils.createTestExchange();
        TradeService tradeService = btcMarketsExchange.getTradeService();
        OpenOrdersParamCurrencyPair openOrdersParams = (OpenOrdersParamCurrencyPair)tradeService.createOpenOrdersParams();
        openOrdersParams.setCurrencyPair(CurrencyPair.BTC_AUD);
        System.out.println("Open Orders: " + tradeService.getOpenOrders((OpenOrdersParams)openOrdersParams));
        LimitOrder sellOrder = new LimitOrder(Order.OrderType.ASK, new BigDecimal("0.003"), CurrencyPair.BTC_AUD, null, null, new BigDecimal("2000"));
        String limitOrderReturnValue = tradeService.placeLimitOrder(sellOrder);
        System.out.println("Limit Order return value: " + limitOrderReturnValue);
        System.out.println("Waiting a while for the order to get registered...");
        Thread.sleep(2000L);
        System.out.println("Open Orders: " + tradeService.getOpenOrders((OpenOrdersParams)openOrdersParams));
        openOrdersParams.setCurrencyPair(CurrencyPair.LTC_BTC);
        System.out.println("Open Orders for LTC/BTC: " + tradeService.getOpenOrders((OpenOrdersParams)openOrdersParams));
        boolean cancelResult = tradeService.cancelOrder(limitOrderReturnValue);
        System.out.println("Canceling returned " + cancelResult);
        System.out.println("Open Orders: " + tradeService.getOpenOrders((OpenOrdersParams)openOrdersParams));
        MarketOrder sellMarketOrder = new MarketOrder(Order.OrderType.ASK, new BigDecimal("0.003"), CurrencyPair.BTC_AUD, null, null);
        String marketSellOrderId = tradeService.placeMarketOrder(sellMarketOrder);
        System.out.println("Market Order return value: " + marketSellOrderId);
        LimitOrder buyOrder = new LimitOrder(Order.OrderType.BID, new BigDecimal("0.002"), CurrencyPair.BTC_AUD, null, null, new BigDecimal("240"));
        String buyLimiOrderId = tradeService.placeLimitOrder(buyOrder);
        System.out.println("Limit Order return value: " + buyLimiOrderId);
        MarketOrder buyMarketOrder = new MarketOrder(Order.OrderType.BID, new BigDecimal("0.004"), CurrencyPair.BTC_AUD, null, null);
        String buyMarketOrderId = tradeService.placeMarketOrder(buyMarketOrder);
        System.out.println("Market Order return value: " + buyMarketOrderId);
        BTCMarketsTradeService.HistoryParams params = (BTCMarketsTradeService.HistoryParams)tradeService.createTradeHistoryParams();
        params.setPageLength(Integer.valueOf(10));
        params.setCurrencyPair(CurrencyPair.BTC_AUD);
        UserTrades tradeHistory = tradeService.getTradeHistory((TradeHistoryParams)params);
        System.out.println("Trade history: " + tradeHistory);
    }
}

