/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.btctrade.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.btctrade.BTCTradeExchange;
import org.knowm.xchange.btctrade.dto.marketdata.BTCTradeDepth;
import org.knowm.xchange.btctrade.service.BTCTradeMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class DepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange btcTrade = ExchangeFactory.INSTANCE.createExchange(BTCTradeExchange.class.getName());
        DepthDemo.generic(btcTrade);
        DepthDemo.raw(btcTrade);
    }

    private static void generic(Exchange exchange) throws IOException {
        MarketDataService marketDataService = exchange.getMarketDataService();
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_CNY, new Object[0]);
        System.out.println(orderBook);
        System.out.println("asks: " + orderBook.getAsks());
        System.out.println("bids: " + orderBook.getBids());
        System.out.println("size: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
    }

    private static void raw(Exchange exchange) throws IOException {
        BTCTradeMarketDataServiceRaw marketDataService = (BTCTradeMarketDataServiceRaw)exchange.getMarketDataService();
        BTCTradeDepth depth = marketDataService.getBTCTradeDepth();
        System.out.println("size: " + (depth.getAsks().length + depth.getBids().length));
    }
}

