/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.btctrade.marketdata;

import java.io.IOException;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.btctrade.BTCTradeExchange;
import org.knowm.xchange.btctrade.dto.marketdata.BTCTradeTrade;
import org.knowm.xchange.btctrade.service.BTCTradeMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class TradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange btcTrade = ExchangeFactory.INSTANCE.createExchange(BTCTradeExchange.class.getName());
        TradesDemo.generic(btcTrade);
        TradesDemo.raw(btcTrade);
    }

    private static void generic(Exchange exchange) throws IOException {
        MarketDataService marketDataService = exchange.getMarketDataService();
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_CNY, new Object[0]);
        System.out.println(trades);
        System.out.println("Trades count: " + trades.getTrades().size() + ", LastID: " + trades.getlastID());
        trades = marketDataService.getTrades(CurrencyPair.BTC_CNY, new Object[]{0});
        System.out.println(trades);
        System.out.println("Trades count: " + trades.getTrades().size() + ", LastID: " + trades.getlastID());
    }

    private static void raw(Exchange exchange) throws IOException {
        BTCTradeMarketDataServiceRaw marketDataService = (BTCTradeMarketDataServiceRaw)exchange.getMarketDataService();
        BTCTradeTrade[] trades = marketDataService.getBTCTradeTrades();
        System.out.println("Trades count: " + trades.length);
        for (BTCTradeTrade trade : trades) {
            System.out.println(trade.getTid() + "\t" + new Date(trade.getDate() * 1000L) + "\t" + trade.getType() + "\t" + trade.getPrice() + "\t" + trade.getAmount());
        }
        trades = marketDataService.getBTCTradeTrades(0L);
        System.out.println("Trades count: " + trades.length);
        for (BTCTradeTrade trade : trades) {
            System.out.println(trade.getTid() + "\t" + new Date(trade.getDate() * 1000L) + "\t" + trade.getType() + "\t" + trade.getPrice() + "\t" + trade.getAmount());
        }
    }
}

