/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.campbx.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.campbx.CampBXExchange;
import org.knowm.xchange.campbx.dto.marketdata.CampBXOrderBook;
import org.knowm.xchange.campbx.dto.marketdata.CampBXTicker;
import org.knowm.xchange.campbx.service.CampBXMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class CampBXMarketDataDemo {
    public static void main(String[] args) throws IOException {
        Exchange campBXExchange = ExchangeFactory.INSTANCE.createExchange(CampBXExchange.class.getName());
        CampBXMarketDataDemo.generic(campBXExchange);
        CampBXMarketDataDemo.raw(campBXExchange);
    }

    private static void generic(Exchange campBXExchange) throws IOException {
        MarketDataService campBXGenericMarketDataService = campBXExchange.getMarketDataService();
        Ticker ticker = campBXGenericMarketDataService.getTicker(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("Last: " + ticker.getLast());
        System.out.println("Bid: " + ticker.getBid());
        System.out.println("Ask: " + ticker.getAsk());
        OrderBook orderBook = campBXGenericMarketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("Order book: " + orderBook);
    }

    private static void raw(Exchange campBXExchange) throws IOException {
        CampBXMarketDataServiceRaw campBXspecificMarketDataService = (CampBXMarketDataServiceRaw)campBXExchange.getMarketDataService();
        CampBXTicker campBXTicker = campBXspecificMarketDataService.getCampBXTicker();
        System.out.println("Last: " + campBXTicker.getLast());
        System.out.println("Bid: " + campBXTicker.getBid());
        System.out.println("Ask: " + campBXTicker.getAsk());
        CampBXOrderBook campBXOrderBook = campBXspecificMarketDataService.getCampBXOrderBook();
        System.out.println("Order book: " + campBXOrderBook);
    }
}

