/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.campbx.trade;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.campbx.CampBXExchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.service.trade.TradeService;

public class CampBXTradeDemo {
    public static void main(String[] args) throws IOException {
        Exchange campbx = ExchangeFactory.INSTANCE.createExchange(CampBXExchange.class.getName());
        ExchangeSpecification exSpec = campbx.getExchangeSpecification();
        exSpec.setUserName("XChange");
        exSpec.setPassword("The Java API");
        TradeService tradeService = campbx.getTradeService();
        CampBXTradeDemo.printOpenOrders(tradeService);
        LimitOrder lo = new LimitOrder(Order.OrderType.ASK, new BigDecimal("0.1"), CurrencyPair.BTC_USD, "", null, new BigDecimal("28.99"));
        String rv = tradeService.placeLimitOrder(lo);
        System.out.println("Limit Order return value: " + rv);
        LimitOrder limitOrder = new LimitOrder(Order.OrderType.ASK, new BigDecimal("0.1"), CurrencyPair.BTC_USD, "", null, new BigDecimal("110"));
        String limitOrderReturnValue = tradeService.placeLimitOrder(limitOrder);
        System.out.println("Limit Order return value: " + limitOrderReturnValue);
        CampBXTradeDemo.printOpenOrders(tradeService);
        boolean cancelResult = tradeService.cancelOrder(limitOrderReturnValue);
        System.out.println("Canceling returned " + cancelResult);
        CampBXTradeDemo.printOpenOrders(tradeService);
    }

    private static void printOpenOrders(TradeService tradeService) throws IOException {
        OpenOrders openOrders = tradeService.getOpenOrders();
        System.out.println("Open Orders: " + openOrders.toString());
    }
}

