/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.ccex.marketdata;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ccex.CCEXExchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class DepthChartDemo {
    public static void main(String[] args) throws IOException {
        Exchange ccexExchange = ExchangeFactory.INSTANCE.createExchange(CCEXExchange.class.getName());
        MarketDataService marketDataService = ccexExchange.getMarketDataService();
        System.out.println("fetching data...");
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.XAUR_BTC, new Object[0]);
        System.out.println("received data.");
        for (LimitOrder limitOrder : orderBook.getBids()) {
            System.out.println(limitOrder.getType() + " " + limitOrder.getCurrencyPair() + " Limit price: " + limitOrder.getLimitPrice() + " Amount: " + limitOrder.getOriginalAmount());
        }
        for (LimitOrder limitOrder : orderBook.getAsks()) {
            System.out.println(limitOrder.getType() + " " + limitOrder.getCurrencyPair() + " Limit price: " + limitOrder.getLimitPrice() + " Amount: " + limitOrder.getOriginalAmount());
        }
        System.out.println("plotting...");
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title("C-CEX Order Book - Xaurum")).xAxisTitle("BTC").yAxisTitle("Amount").build();
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        ArrayList<BigDecimal> xData = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> yData = new ArrayList<BigDecimal>();
        BigDecimal accumulatedBidUnits = new BigDecimal("0");
        for (LimitOrder limitOrder : orderBook.getBids()) {
            xData.add(limitOrder.getLimitPrice());
            accumulatedBidUnits = accumulatedBidUnits.add(limitOrder.getOriginalAmount());
            yData.add(accumulatedBidUnits);
        }
        Collections.reverse(xData);
        Collections.reverse(yData);
        XYSeries series = chart.addSeries("bids", xData, yData);
        series.setMarker(SeriesMarkers.NONE);
        xData = new ArrayList();
        yData = new ArrayList();
        BigDecimal accumulatedAskUnits = new BigDecimal("0");
        for (LimitOrder limitOrder : orderBook.getAsks()) {
            xData.add(limitOrder.getLimitPrice());
            accumulatedAskUnits = accumulatedAskUnits.add(limitOrder.getOriginalAmount());
            yData.add(accumulatedAskUnits);
        }
        series = chart.addSeries("asks", xData, yData);
        series.setMarker(SeriesMarkers.NONE);
        new SwingWrapper((Chart)chart).displayChart();
    }
}

