/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.cexio.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.cexio.CexIOExchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class DepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange exchange = ExchangeFactory.INSTANCE.createExchange(CexIOExchange.class.getName());
        MarketDataService marketDataService = exchange.getMarketDataService();
        OrderBook orderBook = marketDataService.getOrderBook(new CurrencyPair(Currency.GHs, Currency.BTC), new Object[0]);
        System.out.println("Current Order Book size for GHS/BTC: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println("Timestamp: " + orderBook.getTimeStamp().toString());
    }
}

