/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.cryptopia.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.cryptopia.CryptopiaExchange;
import org.knowm.xchange.cryptopia.dto.marketdata.CryptopiaTicker;
import org.knowm.xchange.cryptopia.service.CryptopiaMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class CryptopiaTickerDemo {
    public static void main(String[] args) throws IOException {
        Exchange cryptopia = ExchangeFactory.INSTANCE.createExchange(CryptopiaExchange.class.getName());
        MarketDataService marketDataService = cryptopia.getMarketDataService();
        CryptopiaTickerDemo.generic(marketDataService);
        CryptopiaTickerDemo.raw((CryptopiaMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        Ticker ticker = marketDataService.getTicker(CurrencyPair.ETH_BTC, new Object[0]);
        System.out.println(ticker.toString());
    }

    private static void raw(CryptopiaMarketDataServiceRaw marketDataService) throws IOException {
        CryptopiaTicker cryptopiaTicker = marketDataService.getCryptopiaTicker(CurrencyPair.ETH_BTC);
        System.out.println(cryptopiaTicker.toString());
    }
}

