/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.cryptopia.marketdata;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.cryptopia.CryptopiaExchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class DepthChartDemo {
    public static void main(String[] args) throws IOException {
        Exchange cryptopia = ExchangeFactory.INSTANCE.createExchange(CryptopiaExchange.class.getName());
        MarketDataService marketDataService = cryptopia.getMarketDataService();
        System.out.println("fetching data...");
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.ETH_BTC, new Object[0]);
        System.out.println("received data.");
        System.out.println("plotting...");
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(800)).height(600)).title("Cryptopia Order Book")).xAxisTitle("BTC").yAxisTitle("ETH").build();
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
        ArrayList<BigDecimal> xData = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> yData = new ArrayList<BigDecimal>();
        BigDecimal accumulatedBidUnits = new BigDecimal("0");
        for (LimitOrder limitOrder : orderBook.getBids()) {
            if (!(limitOrder.getLimitPrice().doubleValue() > 0.01)) continue;
            xData.add(limitOrder.getLimitPrice());
            accumulatedBidUnits = accumulatedBidUnits.add(limitOrder.getOriginalAmount());
            yData.add(accumulatedBidUnits);
        }
        Collections.reverse(xData);
        Collections.reverse(yData);
        XYSeries series = chart.addSeries("bids", xData, yData);
        series.setMarker(SeriesMarkers.NONE);
        xData = new ArrayList();
        yData = new ArrayList();
        BigDecimal accumulatedAskUnits = new BigDecimal("0");
        for (LimitOrder limitOrder : orderBook.getAsks()) {
            if (!(limitOrder.getLimitPrice().doubleValue() < 1.0)) continue;
            xData.add(limitOrder.getLimitPrice());
            accumulatedAskUnits = accumulatedAskUnits.add(limitOrder.getOriginalAmount());
            yData.add(accumulatedAskUnits);
        }
        series = chart.addSeries("asks", xData, yData);
        series.setMarker(SeriesMarkers.NONE);
        new SwingWrapper((Chart)chart).displayChart();
    }
}

