/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.cryptopia.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.cryptopia.CryptopiaExchange;
import org.knowm.xchange.cryptopia.dto.marketdata.CryptopiaOrder;
import org.knowm.xchange.cryptopia.dto.marketdata.CryptopiaOrderBook;
import org.knowm.xchange.cryptopia.service.CryptopiaMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class DepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange cryptopia = ExchangeFactory.INSTANCE.createExchange(CryptopiaExchange.class.getName());
        MarketDataService marketDataService = cryptopia.getMarketDataService();
        DepthDemo.generic(marketDataService);
        DepthDemo.raw((CryptopiaMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.ETH_BTC, new Object[0]);
        System.out.println("Current Order Book size for BTC / USD: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("Last Ask: " + ((LimitOrder)orderBook.getAsks().get(orderBook.getAsks().size() - 1)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println("Last Bid: " + ((LimitOrder)orderBook.getBids().get(orderBook.getBids().size() - 1)).toString());
    }

    private static void raw(CryptopiaMarketDataServiceRaw marketDataService) throws IOException {
        CryptopiaOrderBook orderBook = marketDataService.getCryptopiaOrderBook(CurrencyPair.ETH_BTC);
        System.out.println("Current Order Book size for BTC / USD: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((CryptopiaOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("First Bid: " + ((CryptopiaOrder)orderBook.getBids().get(0)).toString());
    }
}

