/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.dsx.marketdata;

import java.io.IOException;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dsx.DSXExchange;
import org.knowm.xchange.dsx.dto.marketdata.DSXTrade;
import org.knowm.xchange.dsx.service.DSXMarketDataServiceRaw;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class DSXTradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange dsx = ExchangeFactory.INSTANCE.createExchange(DSXExchange.class.getName());
        DSXTradesDemo.generic(dsx);
        DSXTradesDemo.raw(dsx);
    }

    private static void generic(Exchange exchange) throws IOException {
        MarketDataService marketDataService = exchange.getMarketDataService();
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_EUR, new Object[0]);
        System.out.println(trades.toString());
    }

    private static void raw(Exchange exchange) throws IOException {
        DSXMarketDataServiceRaw marketDataService = (DSXMarketDataServiceRaw)exchange.getMarketDataService();
        Map trades = marketDataService.getDSXTrades("btcusd", 7, "LIVE").getTradesMap();
        for (Map.Entry entry : trades.entrySet()) {
            System.out.println("Pair: " + (String)entry.getKey() + ", Trades:");
            for (DSXTrade trade : (DSXTrade[])entry.getValue()) {
                System.out.println(trade.toString());
            }
        }
    }
}

