/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.gatecoin.account;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.examples.gatecoin.GatecoinDemoUtils;
import org.knowm.xchange.gatecoin.dto.account.GatecoinBalance;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinBalanceResult;
import org.knowm.xchange.gatecoin.service.GatecoinAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;

public class GatecoinAccountInfoDemo {
    public static void main(String[] args) throws IOException {
        Exchange gatecoin = GatecoinDemoUtils.createExchange();
        AccountService accountService = gatecoin.getAccountService();
        GatecoinAccountInfoDemo.generic(accountService);
        GatecoinAccountInfoDemo.raw((GatecoinAccountServiceRaw)accountService);
    }

    private static void generic(AccountService accountService) throws IOException {
        AccountInfo accountInfo = accountService.getAccountInfo();
        System.out.println("Wallet: " + accountInfo);
        System.out.println("BTC balance: " + accountInfo.getWallet().getBalance(Currency.BTC).getAvailable());
    }

    private static void raw(GatecoinAccountServiceRaw accountService) throws IOException {
        GatecoinBalanceResult gatecoinBalanceResult = accountService.getGatecoinBalance();
        for (GatecoinBalance balance : gatecoinBalanceResult.getBalances()) {
            System.out.println("GatecoinBalance: " + balance);
        }
    }
}

