/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.gatecoin.marketdata;

import java.io.IOException;
import java.util.Arrays;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.gatecoin.GatecoinExchange;
import org.knowm.xchange.gatecoin.service.GatecoinMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class GatecoinDepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange gatecoin = ExchangeFactory.INSTANCE.createExchange(GatecoinExchange.class.getName());
        MarketDataService marketDataService = gatecoin.getMarketDataService();
        GatecoinDepthDemo.generic(marketDataService);
        GatecoinDepthDemo.raw((GatecoinMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(orderBook.toString());
    }

    private static void raw(GatecoinMarketDataServiceRaw marketDataService) throws IOException {
        Object[] asks = marketDataService.getGatecoinOrderBook(CurrencyPair.BTC_USD.toString()).getAsks();
        System.out.println(Arrays.toString(asks));
    }
}

