/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.gatecoin.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.gatecoin.GatecoinExchange;
import org.knowm.xchange.gatecoin.dto.marketdata.GatecoinTransaction;
import org.knowm.xchange.gatecoin.service.GatecoinMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class GatecoinTradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange gatecoin = ExchangeFactory.INSTANCE.createExchange(GatecoinExchange.class.getName());
        MarketDataService marketDataService = gatecoin.getMarketDataService();
        GatecoinTradesDemo.generic(marketDataService);
        GatecoinTradesDemo.raw((GatecoinMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(trades.getTrades().toString());
        Trades tradesWithCount = marketDataService.getTrades(CurrencyPair.BTC_EUR, new Object[]{10});
        System.out.println(tradesWithCount.getTrades().toString());
        Trades tradesWithCountAndTxId = marketDataService.getTrades(CurrencyPair.BTC_HKD, new Object[]{5, 1386153L});
        System.out.println(tradesWithCountAndTxId.getTrades().toString());
    }

    private static void raw(GatecoinMarketDataServiceRaw marketDataService) throws IOException {
        GatecoinTransaction[] gatecoinTransactions = marketDataService.getGatecoinTransactions(CurrencyPair.BTC_USD.toString()).getTransactions();
        System.out.println(gatecoinTransactions[0].toString());
    }
}

