/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.gatecoin.trade;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.examples.gatecoin.GatecoinDemoUtils;
import org.knowm.xchange.gatecoin.dto.trade.GatecoinTradeHistory;
import org.knowm.xchange.gatecoin.dto.trade.Results.GatecoinTradeHistoryResult;
import org.knowm.xchange.gatecoin.service.GatecoinTradeService;
import org.knowm.xchange.gatecoin.service.GatecoinTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;

public class GatecoinTradeHistoryDemo {
    public static void main(String[] args) throws IOException {
        Exchange gatecoin = GatecoinDemoUtils.createExchange();
        TradeService tradeService = gatecoin.getTradeService();
        GatecoinTradeHistoryDemo.generic(tradeService);
        GatecoinTradeHistoryDemo.raw((GatecoinTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws IOException {
        UserTrades result = tradeService.getTradeHistory(tradeService.createTradeHistoryParams());
        System.out.println("Trade history returned " + result);
        result = tradeService.getTradeHistory((TradeHistoryParams)new GatecoinTradeService.GatecoinTradeHistoryParams(Integer.valueOf(10)));
        System.out.println("Trade history returned " + result);
        result = tradeService.getTradeHistory((TradeHistoryParams)new GatecoinTradeService.GatecoinTradeHistoryParams(Integer.valueOf(10), "24561"));
        System.out.println("Trade history returned " + result);
    }

    private static void raw(GatecoinTradeServiceRaw tradeService) throws IOException {
        GatecoinTradeHistoryDemo.printRawTradeHistory(tradeService);
    }

    private static void printRawTradeHistory(GatecoinTradeServiceRaw tradeService) throws IOException {
        GatecoinTradeHistoryResult tradeHistoryResult = tradeService.getGatecoinUserTrades();
        System.out.println("Trades: " + tradeHistoryResult.getTransactions().length);
        for (GatecoinTradeHistory trade : tradeHistoryResult.getTransactions()) {
            System.out.println(trade.toString());
        }
    }
}

