/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.gdax;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.gdax.GDAXExchange;
import org.knowm.xchange.gdax.dto.marketdata.GDAXProductBook;
import org.knowm.xchange.gdax.service.GDAXMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class GDAXDepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange exchange = ExchangeFactory.INSTANCE.createExchange(GDAXExchange.class.getName());
        MarketDataService marketDataService = exchange.getMarketDataService();
        GDAXDepthDemo.generic(marketDataService);
        GDAXDepthDemo.raw((GDAXMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[]{3});
        System.out.println("Current Order Book size for BTC / USD: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("Last Ask: " + ((LimitOrder)orderBook.getAsks().get(orderBook.getAsks().size() - 1)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println("Last Bid: " + ((LimitOrder)orderBook.getBids().get(orderBook.getBids().size() - 1)).toString());
        System.out.println(orderBook.toString());
    }

    private static void raw(GDAXMarketDataServiceRaw marketDataService) throws IOException {
        GDAXProductBook orderBook = marketDataService.getCoinbaseExProductOrderBook(CurrencyPair.BTC_USD, 2);
        System.out.println("Current Order Book size for BTC / USD: " + (orderBook.getAsks().length + orderBook.getBids().length));
        System.out.println("First Ask: " + orderBook.getAsks()[0].toString());
        System.out.println("First Bid: " + orderBook.getBids()[0].toString());
        System.out.println(orderBook.toString());
    }
}

