/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.gdax;

import java.io.IOException;
import java.util.Arrays;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.gdax.GDAXExchange;
import org.knowm.xchange.gdax.service.GDAXMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class GDAXTradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange exchange = ExchangeFactory.INSTANCE.createExchange(GDAXExchange.class.getName());
        MarketDataService marketDataService = exchange.getMarketDataService();
        GDAXTradesDemo.generic(marketDataService);
        GDAXTradesDemo.raw((GDAXMarketDataServiceRaw)marketDataService);
    }

    public static void generic(MarketDataService marketDataService) throws IOException {
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(trades);
    }

    public static void raw(GDAXMarketDataServiceRaw marketDataServiceRaw) throws IOException {
        Object[] trades = marketDataServiceRaw.getCoinbaseExTrades(CurrencyPair.BTC_USD);
        System.out.println(Arrays.toString(trades));
    }
}

