/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.independentreserve.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.independentreserve.IndependentReserveExchange;
import org.knowm.xchange.independentreserve.dto.marketdata.IndependentReserveOrderBook;
import org.knowm.xchange.independentreserve.dto.marketdata.OrderBookOrder;
import org.knowm.xchange.independentreserve.service.IndependentReserveMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class DepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange independentReserve = ExchangeFactory.INSTANCE.createExchange(IndependentReserveExchange.class.getName());
        MarketDataService marketDataService = independentReserve.getMarketDataService();
        DepthDemo.generic(marketDataService);
        DepthDemo.raw((IndependentReserveMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("Current Order Book size for BTC / USD: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("Last Ask: " + ((LimitOrder)orderBook.getAsks().get(orderBook.getAsks().size() - 1)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println("Last Bid: " + ((LimitOrder)orderBook.getBids().get(orderBook.getBids().size() - 1)).toString());
        System.out.println(orderBook.toString());
    }

    private static void raw(IndependentReserveMarketDataServiceRaw marketDataService) throws IOException {
        IndependentReserveOrderBook orderBook = marketDataService.getIndependentReserveOrderBook(Currency.BTC.getCurrencyCode(), Currency.USD.getCurrencyCode());
        System.out.println("Current Order Book size for BTC / USD: " + (orderBook.getSellOrders().size() + orderBook.getBuyOrders().size()));
        System.out.println("First Ask: " + ((OrderBookOrder)orderBook.getSellOrders().get(0)).toString());
        System.out.println("First Bid: " + ((OrderBookOrder)orderBook.getBuyOrders().get(0)).toString());
        System.out.println(orderBook.toString());
    }
}

