/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.independentreserve.trade;

import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.examples.independentreserve.IndependentReserveDemoUtils;
import org.knowm.xchange.examples.independentreserve.trade.IndependentReserveTradeDemo;
import org.knowm.xchange.service.trade.TradeService;

public class IndependentReserveTradeDemoEth {
    public static void main(String[] args) throws Exception {
        Exchange independentReserve = IndependentReserveDemoUtils.createExchange();
        TradeService tradeService = independentReserve.getTradeService();
        IndependentReserveTradeDemoEth.generic(tradeService);
    }

    private static void generic(TradeService tradeService) throws Exception {
        IndependentReserveTradeDemo.printOpenOrders(tradeService);
        LimitOrder limitOrder = new LimitOrder(Order.OrderType.ASK, new BigDecimal(".01"), CurrencyPair.ETH_USD, "", null, new BigDecimal("1000.00"));
        String limitOrderReturnValue = tradeService.placeLimitOrder(limitOrder);
        System.out.println("Limit Order return value: " + limitOrderReturnValue);
        IndependentReserveTradeDemo.printOpenOrders(tradeService);
        boolean cancelResult = tradeService.cancelOrder(limitOrderReturnValue);
        System.out.println("Canceling returned " + cancelResult);
        IndependentReserveTradeDemo.printOpenOrders(tradeService);
        UserTrades tradeHistory = tradeService.getTradeHistory(tradeService.createTradeHistoryParams());
        System.out.println("Trade history: " + tradeHistory.toString());
    }
}

