/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.itbit.market;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.itbit.v1.ItBitExchange;
import org.knowm.xchange.itbit.v1.dto.marketdata.ItBitDepth;
import org.knowm.xchange.itbit.v1.service.ItBitMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class ItBitOrderBookDemo {
    public static void main(String[] args) throws IOException {
        Exchange xchange = ExchangeFactory.INSTANCE.createExchange(ItBitExchange.class.getName());
        MarketDataService marketDataService = xchange.getMarketDataService();
        ItBitOrderBookDemo.generic(marketDataService);
        ItBitOrderBookDemo.raw((ItBitMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(orderBook.toString());
        OrderBook orderBookAsXBT = marketDataService.getOrderBook(new CurrencyPair(Currency.XBT, Currency.USD), new Object[0]);
        System.out.println(orderBookAsXBT.toString());
    }

    private static void raw(ItBitMarketDataServiceRaw marketDataService) throws IOException {
        ItBitDepth orderBook = marketDataService.getItBitDepth(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(orderBook.toString());
    }
}

