/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.koineks.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.examples.koineks.KoineksDemoUtils;
import org.knowm.xchange.koineks.dto.marketdata.KoineksTicker;
import org.knowm.xchange.koineks.service.KoineksMarketDataService;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class KoineksTickerDemo {
    public static void main(String[] args) throws IOException {
        Exchange koineks = KoineksDemoUtils.createExchange();
        MarketDataService marketDataService = koineks.getMarketDataService();
        KoineksTickerDemo.generic(marketDataService);
        KoineksTickerDemo.raw((KoineksMarketDataService)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        Ticker btcTicker = marketDataService.getTicker(CurrencyPair.BTC_TRY, new Object[0]);
        Ticker ethTicker = marketDataService.getTicker(CurrencyPair.ETH_TRY, new Object[0]);
        Ticker ltcTicker = marketDataService.getTicker(CurrencyPair.LTC_TRY, new Object[0]);
        Ticker dogeTicker = marketDataService.getTicker(CurrencyPair.DOGE_TRY, new Object[0]);
        Ticker dashTicker = marketDataService.getTicker(CurrencyPair.DASH_TRY, new Object[0]);
        System.out.println(btcTicker);
        System.out.println(ethTicker);
        System.out.println(ltcTicker);
        System.out.println(dogeTicker);
        System.out.println(dashTicker);
    }

    private static void raw(KoineksMarketDataService marketDataService) throws IOException {
        KoineksTicker koineksTicker = marketDataService.getKoineksTicker();
        System.out.println(koineksTicker.toString());
    }
}

