/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.kraken.account;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.examples.kraken.KrakenExampleUtils;
import org.knowm.xchange.examples.util.AccountServiceTestUtil;
import org.knowm.xchange.kraken.service.KrakenAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencies;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;

public class KrakenAccountDemo {
    public static void main(String[] args) throws IOException {
        Exchange krakenExchange = KrakenExampleUtils.createTestExchange();
        KrakenAccountDemo.generic(krakenExchange);
        KrakenAccountDemo.raw(krakenExchange);
    }

    private static void generic(Exchange krakenExchange) throws IOException {
        AccountInfo accountInfo = krakenExchange.getAccountService().getAccountInfo();
        System.out.println("Account Info: " + accountInfo.toString());
        KrakenAccountDemo.fundingHistory(krakenExchange.getAccountService());
    }

    private static void raw(Exchange krakenExchange) throws IOException {
        KrakenAccountServiceRaw rawKrakenAcctService = (KrakenAccountServiceRaw)krakenExchange.getAccountService();
        System.out.println("Balance Info: " + rawKrakenAcctService.getKrakenBalance());
    }

    private static void fundingHistory(AccountService accountService) throws IOException {
        TradeHistoryParams params = accountService.createFundingHistoryParams();
        if (params instanceof TradeHistoryParamsTimeSpan) {
            TradeHistoryParamsTimeSpan timeSpanParam = (TradeHistoryParamsTimeSpan)params;
            timeSpanParam.setStartTime(new Date(System.currentTimeMillis() - 31104000000L));
        }
        if (params instanceof HistoryParamsFundingType) {
            ((HistoryParamsFundingType)params).setType(FundingRecord.Type.DEPOSIT);
        }
        if (params instanceof TradeHistoryParamCurrencies) {
            TradeHistoryParamCurrencies currenciesParam = (TradeHistoryParamCurrencies)params;
            currenciesParam.setCurrencies(new Currency[]{Currency.BTC, Currency.USD});
        }
        List fundingRecords = accountService.getFundingHistory(params);
        AccountServiceTestUtil.printFundingHistory(fundingRecords);
    }
}

