/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.kraken.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.kraken.KrakenExchange;
import org.knowm.xchange.kraken.dto.marketdata.KrakenPublicTrade;
import org.knowm.xchange.kraken.dto.marketdata.KrakenPublicTrades;
import org.knowm.xchange.kraken.service.KrakenMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class KrakenTradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange krakenExchange = ExchangeFactory.INSTANCE.createExchange(KrakenExchange.class.getName());
        KrakenTradesDemo.generic(krakenExchange);
    }

    private static void generic(Exchange krakenExchange) throws IOException {
        MarketDataService marketDataService = krakenExchange.getMarketDataService();
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(trades);
        System.out.println("Trades(0): " + ((Trade)trades.getTrades().get(0)).toString());
        System.out.println("Trades size: " + trades.getTrades().size());
    }

    private static void raw(Exchange krakenExchange) throws IOException {
        KrakenMarketDataServiceRaw krakenMarketDataService = (KrakenMarketDataServiceRaw)krakenExchange.getMarketDataService();
        KrakenPublicTrades krakenPublicTrades = krakenMarketDataService.getKrakenTrades(CurrencyPair.BTC_USD);
        long last = krakenPublicTrades.getLast();
        System.out.println(krakenPublicTrades.getTrades());
        System.out.println("Trades size: " + krakenPublicTrades.getTrades().size());
        System.out.println("Trades(0): " + ((KrakenPublicTrade)krakenPublicTrades.getTrades().get(0)).toString());
        System.out.println("Last: " + last);
        krakenPublicTrades = krakenMarketDataService.getKrakenTrades(CurrencyPair.LTC_USD, Long.valueOf(last));
        System.out.println(krakenPublicTrades.getTrades());
        System.out.println("Trades size: " + krakenPublicTrades.getTrades().size());
    }
}

