/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.kraken.trade;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.examples.kraken.KrakenExampleUtils;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderResponse;
import org.knowm.xchange.kraken.dto.trade.KrakenOrderType;
import org.knowm.xchange.kraken.dto.trade.KrakenStandardOrder;
import org.knowm.xchange.kraken.dto.trade.KrakenType;
import org.knowm.xchange.kraken.service.KrakenTradeServiceRaw;

public class KrakenTradeRawSpecificDemo {
    public static void main(String[] args) throws IOException {
        Exchange krakenExchange = KrakenExampleUtils.createTestExchange();
        KrakenTradeServiceRaw tradeService = (KrakenTradeServiceRaw)krakenExchange.getTradeService();
        KrakenStandardOrder order = KrakenStandardOrder.getLimitOrderBuilder((CurrencyPair)CurrencyPair.BTC_USD, (KrakenType)KrakenType.BUY, (String)"100.00", (BigDecimal)new BigDecimal("2.12345678")).withCloseOrder(KrakenOrderType.STOP_LOSS_PROFIT, "#5%", "#10").withValidateOnly(true).buildOrder();
        KrakenOrderResponse orderResponse = tradeService.placeKrakenOrder(order);
        System.out.println(orderResponse);
        Map openOrders = tradeService.getKrakenOpenOrders();
        System.out.println(openOrders);
        KrakenTradeRawSpecificDemo.limitRate();
        Map closedOrders = tradeService.getKrakenClosedOrders();
        System.out.println(closedOrders);
        Set closedOrderIds = closedOrders.keySet();
        System.out.println(tradeService.queryKrakenOrders(closedOrderIds.toArray(new String[closedOrderIds.size()])));
        Map trades = tradeService.getKrakenTradeHistory();
        System.out.println(trades);
        Set tradeIds = trades.keySet();
        System.out.println(tradeService.queryKrakenTrades(tradeIds.toArray(new String[tradeIds.size()])));
        Map openPositions = tradeService.getOpenPositions();
        System.out.println(openPositions);
    }

    private static void limitRate() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

