/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.liqui.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.examples.liqui.LiquiExampleUtil;
import org.knowm.xchange.liqui.dto.marketdata.LiquiDepth;
import org.knowm.xchange.liqui.service.LiquiMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class LiquiDepthDemo {
    public static final void main(String[] args) throws IOException {
        Exchange exchange = LiquiExampleUtil.createTestExchange();
        LiquiDepthDemo.generic(exchange);
        LiquiDepthDemo.raw(exchange);
    }

    private static void generic(Exchange liquiExchange) throws IOException {
        MarketDataService marketDataService = liquiExchange.getMarketDataService();
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.LTC_BTC, new Object[0]);
        System.out.println(orderBook.toString());
        System.out.println("full orderbook size: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
    }

    private static void raw(Exchange liquiExchange) throws IOException {
        LiquiMarketDataServiceRaw liquiMarketDataServiceRaw = (LiquiMarketDataServiceRaw)liquiExchange.getMarketDataService();
        LiquiDepth depth = liquiMarketDataServiceRaw.getDepth(CurrencyPair.LTC_BTC, 5);
        System.out.println(depth.toString());
        System.out.println("size: " + (depth.getAsks().size() + depth.getBids().size()));
    }
}

