/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.liqui.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.examples.liqui.LiquiExampleUtil;
import org.knowm.xchange.liqui.dto.marketdata.LiquiTicker;
import org.knowm.xchange.liqui.service.LiquiMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class LiquiTickerDemo {
    public static final void main(String[] args) throws IOException {
        Exchange exchange = LiquiExampleUtil.createTestExchange();
        LiquiTickerDemo.generic(exchange);
        LiquiTickerDemo.raw(exchange);
    }

    private static void generic(Exchange liquiExchange) throws IOException {
        MarketDataService marketDataService = liquiExchange.getMarketDataService();
        Ticker ticker = marketDataService.getTicker(CurrencyPair.LTC_BTC, new Object[0]);
        System.out.println("Ticker: " + ticker.toString());
        System.out.println("Currency: " + Currency.LTC);
        System.out.println("Last: " + ticker.getLast().toString());
        System.out.println("Volume: " + ticker.getVolume().toString());
        System.out.println("High: " + ticker.getHigh().toString());
        System.out.println("Low: " + ticker.getLow().toString());
    }

    private static void raw(Exchange liquiExchange) throws IOException {
        LiquiMarketDataServiceRaw liquiMarketDataServiceRaw = (LiquiMarketDataServiceRaw)liquiExchange.getMarketDataService();
        LiquiTicker ticker = liquiMarketDataServiceRaw.getTicker(CurrencyPair.LTC_BTC);
        System.out.println("Ticker: " + ticker.toString());
        System.out.println("Currency: " + Currency.LTC);
        System.out.println("Last: " + ticker.getLast());
        System.out.println("Volume: " + ticker.getVol().toString());
        System.out.println("High: " + ticker.getHigh().toString());
        System.out.println("Low: " + ticker.getLow().toString());
    }
}

