/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.livecoin.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.livecoin.LivecoinExchange;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class OrderBookDemo {
    public static void main(String[] args) throws IOException {
        Exchange livecoinExchange = ExchangeFactory.INSTANCE.createExchange(LivecoinExchange.class.getName());
        MarketDataService marketDataService = livecoinExchange.getMarketDataService();
        System.out.println("fetching data...");
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("received data.");
        for (LimitOrder limitOrder : orderBook.getBids()) {
            System.out.println(limitOrder.getType() + " " + limitOrder.getCurrencyPair() + " Limit price: " + limitOrder.getLimitPrice() + " Amount: " + limitOrder.getOriginalAmount());
        }
        for (LimitOrder limitOrder : orderBook.getAsks()) {
            System.out.println(limitOrder.getType() + " " + limitOrder.getCurrencyPair() + " Limit price: " + limitOrder.getLimitPrice() + " Amount: " + limitOrder.getOriginalAmount());
        }
    }
}

