/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.mercadobitcoin.marketdata.ltc;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.mercadobitcoin.MercadoBitcoinExchange;
import org.knowm.xchange.mercadobitcoin.dto.marketdata.MercadoBitcoinOrderBook;
import org.knowm.xchange.mercadobitcoin.service.MercadoBitcoinMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class DepthDemo {
    public static void main(String[] args) throws IOException {
        Exchange mercadoBitcoin = ExchangeFactory.INSTANCE.createExchange(MercadoBitcoinExchange.class.getName());
        MarketDataService marketDataService = mercadoBitcoin.getMarketDataService();
        DepthDemo.generic(marketDataService);
        DepthDemo.raw((MercadoBitcoinMarketDataServiceRaw)marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        OrderBook orderBook = marketDataService.getOrderBook(new CurrencyPair(Currency.LTC, Currency.BRL), new Object[0]);
        System.out.println("Current Order Book size for LTC / BRL: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((LimitOrder)orderBook.getAsks().get(0)).toString());
        System.out.println("Last Ask: " + ((LimitOrder)orderBook.getAsks().get(orderBook.getAsks().size() - 1)).toString());
        System.out.println("First Bid: " + ((LimitOrder)orderBook.getBids().get(0)).toString());
        System.out.println("Last Bid: " + ((LimitOrder)orderBook.getBids().get(orderBook.getBids().size() - 1)).toString());
        System.out.println(orderBook.toString());
    }

    private static void raw(MercadoBitcoinMarketDataServiceRaw marketDataService) throws IOException {
        MercadoBitcoinOrderBook orderBook = marketDataService.getMercadoBitcoinOrderBook(new CurrencyPair(Currency.LTC, Currency.BRL));
        System.out.println("Current Order Book size for LTC / BRL: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
        System.out.println("First Ask: " + ((List)orderBook.getAsks().get(0)).toString());
        System.out.println("First Bid: " + ((List)orderBook.getBids().get(0)).toString());
        System.out.println(orderBook.toString());
    }
}

