/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.mercadobitcoin.marketdata.ltc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.mercadobitcoin.MercadoBitcoinExchange;
import org.knowm.xchange.mercadobitcoin.service.MercadoBitcoinMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class TradesDemo {
    public static void main(String[] args) throws IOException {
        Exchange mercadoBitcoin = ExchangeFactory.INSTANCE.createExchange(MercadoBitcoinExchange.class.getName());
        MarketDataService marketDataService = mercadoBitcoin.getMarketDataService();
        Long now = new Date().getTime();
        TradesDemo.generic(now, marketDataService);
        TradesDemo.raw(now, (MercadoBitcoinMarketDataServiceRaw)marketDataService);
    }

    private static void generic(Long now, MarketDataService marketDataService) throws IOException {
        Trades trades = marketDataService.getTrades(new CurrencyPair(Currency.LTC, Currency.BRL), new Object[0]);
        System.out.println("Trades, default. Size= " + trades.getTrades().size());
        trades = marketDataService.getTrades(new CurrencyPair(Currency.LTC, Currency.BRL), new Object[]{now - 86400000L});
        System.out.println("Trades, last 24h= " + trades.getTrades().size());
        trades = marketDataService.getTrades(new CurrencyPair(Currency.LTC, Currency.BRL), new Object[]{1406851200000L, 1409529600000L});
        System.out.println("Trades, since Aug 2014 to Sep 2014= " + trades.getTrades().size());
        System.out.println(trades.toString());
    }

    private static void raw(Long now, MercadoBitcoinMarketDataServiceRaw marketDataService) throws IOException {
        Object[] trades = marketDataService.getMercadoBitcoinTransactions(new CurrencyPair(Currency.LTC, Currency.BRL), new Object[0]);
        System.out.println("Trades, default. Size= " + trades.length);
        trades = marketDataService.getMercadoBitcoinTransactions(new CurrencyPair(Currency.LTC, Currency.BRL), new Object[]{now - 86400000L});
        System.out.println("Trades, last 24h= " + trades.length);
        trades = marketDataService.getMercadoBitcoinTransactions(new CurrencyPair(Currency.LTC, Currency.BRL), new Object[]{1406851200000L, 1409529600000L});
        System.out.println("Trades, since Aug 2014 to Sep 2014= " + trades.length);
        System.out.println(Arrays.toString(trades));
    }
}

