/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.mercadobitcoin.trade;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.examples.mercadobitcoin.InteractiveAuthenticatedExchange;
import org.knowm.xchange.mercadobitcoin.dto.MercadoBitcoinBaseTradeApiResult;
import org.knowm.xchange.mercadobitcoin.dto.trade.MercadoBitcoinPlaceLimitOrderResult;
import org.knowm.xchange.mercadobitcoin.dto.trade.MercadoBitcoinUserOrders;
import org.knowm.xchange.mercadobitcoin.service.MercadoBitcoinTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;

public class MercadoBitcoinTradeDemo {
    public static void main(String[] args) throws IOException, InterruptedException {
        Exchange mercadoBitcoin = InteractiveAuthenticatedExchange.createInstanceFromDefaultInput();
        TradeService tradeService = mercadoBitcoin.getTradeService();
        MercadoBitcoinTradeDemo.generic(tradeService);
        MercadoBitcoinTradeDemo.raw((MercadoBitcoinTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws IOException, InterruptedException {
        MercadoBitcoinTradeDemo.printOpenOrders(tradeService);
        LimitOrder limitOrder = new LimitOrder(Order.OrderType.ASK, new BigDecimal("0.01"), CurrencyPair.BTC_BRL, "", null, new BigDecimal("9000.00"));
        String limitOrderReturnValue = tradeService.placeLimitOrder(limitOrder);
        System.out.println("Limit Order return value: " + limitOrderReturnValue);
        MercadoBitcoinTradeDemo.printOpenOrders(tradeService);
        boolean cancelResult = tradeService.cancelOrder(limitOrderReturnValue);
        System.out.println("Canceling returned " + cancelResult);
        MercadoBitcoinTradeDemo.printOpenOrders(tradeService);
    }

    private static void printOpenOrders(TradeService tradeService) throws IOException, InterruptedException {
        OpenOrders openOrders = tradeService.getOpenOrders();
        System.out.println("Open Orders: " + openOrders.toString());
    }

    private static void raw(MercadoBitcoinTradeServiceRaw tradeService) throws IOException, InterruptedException {
        MercadoBitcoinTradeDemo.printRawOpenOrders(tradeService);
        MercadoBitcoinBaseTradeApiResult order = tradeService.mercadoBitcoinPlaceLimitOrder("ltc_brl", "buy", new BigDecimal("0.01"), new BigDecimal("1"));
        System.out.println("MercadoBitcoinBaseTradeApiResult<MercadoBitcoinPlaceLimitOrderResult> return value: " + order);
        MercadoBitcoinTradeDemo.printRawOpenOrders(tradeService);
        MercadoBitcoinBaseTradeApiResult cancelResult = tradeService.mercadoBitcoinCancelOrder("ltc_brl", (String)((MercadoBitcoinPlaceLimitOrderResult)order.getTheReturn()).keySet().iterator().next());
        System.out.println("Canceling returned " + cancelResult);
        MercadoBitcoinTradeDemo.printRawOpenOrders(tradeService);
    }

    private static void printRawOpenOrders(MercadoBitcoinTradeServiceRaw tradeService) throws IOException, InterruptedException {
        MercadoBitcoinBaseTradeApiResult openOrdersResult = tradeService.getMercadoBitcoinUserOrders("btc_brl", null, "active", null, null, null, null);
        MercadoBitcoinUserOrders openOrders = (MercadoBitcoinUserOrders)openOrdersResult.getTheReturn();
        System.out.println("Open Orders for BTC: " + openOrders.size());
        for (Map.Entry order : openOrders.entrySet()) {
            System.out.println(order.toString());
        }
        openOrdersResult = tradeService.getMercadoBitcoinUserOrders("ltc_brl", null, "active", null, null, null, null);
        openOrders = (MercadoBitcoinUserOrders)openOrdersResult.getTheReturn();
        System.out.println("Open Orders for LTC: " + openOrders.size());
        for (Map.Entry order : openOrders.entrySet()) {
            System.out.println(order.toString());
        }
    }
}

