/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.okcoin.account;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.examples.okcoin.OkCoinExampleUtils;
import org.knowm.xchange.examples.util.AccountServiceTestUtil;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;

public class OkCoinAccountDemo {
    public static void main(String[] args) throws IOException {
        Exchange okcoinExchange = OkCoinExampleUtils.createTestExchange();
        OkCoinAccountDemo.generic(okcoinExchange);
    }

    private static void generic(Exchange xchange) throws IOException {
        OkCoinAccountDemo.fundingHistory(xchange.getAccountService());
    }

    private static void fundingHistory(AccountService accountService) throws IOException {
        TradeHistoryParams params = accountService.createFundingHistoryParams();
        if (params instanceof TradeHistoryParamPaging) {
            TradeHistoryParamPaging pagingParams = (TradeHistoryParamPaging)params;
            pagingParams.setPageLength(Integer.valueOf(50));
            pagingParams.setPageNumber(Integer.valueOf(1));
        }
        if (params instanceof TradeHistoryParamCurrencyPair) {
            ((TradeHistoryParamCurrencyPair)params).setCurrencyPair(CurrencyPair.BTC_CNY);
        }
        List fundingRecords = accountService.getFundingHistory(params);
        AccountServiceTestUtil.printFundingHistory(fundingRecords);
    }
}

