/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.openexchangerates.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.oer.OERExchange;
import org.knowm.xchange.oer.dto.marketdata.OERRates;
import org.knowm.xchange.oer.service.OERMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class TickerDemo {
    public static void main(String[] args) throws IOException {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(OERExchange.class.getName());
        exchangeSpecification.setPlainTextUri("http://openexchangerates.org");
        exchangeSpecification.setApiKey("ab32c922bca749ec9345b4717914ee1f");
        Exchange openExchangeRates = ExchangeFactory.INSTANCE.createExchange(exchangeSpecification);
        TickerDemo.generic(openExchangeRates);
        TickerDemo.raw(openExchangeRates);
    }

    private static void generic(Exchange openExchangeRates) throws IOException {
        MarketDataService marketDataService = openExchangeRates.getMarketDataService();
        Ticker ticker = marketDataService.getTicker(CurrencyPair.EUR_USD, new Object[0]);
        System.out.println("Last: " + ticker.getLast().toString());
        System.out.println("ticker: " + ticker.toString());
        ticker = marketDataService.getTicker(CurrencyPair.JPY_USD, new Object[0]);
        System.out.println("cached Last: " + ticker.getLast().toString());
        ticker = marketDataService.getTicker(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println("cached Last: " + ticker.getLast().toString());
    }

    private static void raw(Exchange openExchangeRates) throws IOException {
        OERMarketDataServiceRaw oERMarketDataServiceRaw = (OERMarketDataServiceRaw)openExchangeRates.getMarketDataService();
        OERRates oERRates = oERMarketDataServiceRaw.getOERTicker();
        System.out.println(oERRates.toString());
    }
}

