/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.poloniex.account;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.examples.poloniex.PoloniexExamplesUtils;
import org.knowm.xchange.poloniex.service.PoloniexAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.utils.CertHelper;

public class PoloniexAccountDemo {
    public static void main(String[] args) throws Exception {
        CertHelper.trustAllCerts();
        Exchange poloniex = PoloniexExamplesUtils.getExchange();
        AccountService accountService = poloniex.getAccountService();
        PoloniexAccountDemo.generic(accountService);
        PoloniexAccountDemo.raw((PoloniexAccountServiceRaw)accountService);
    }

    private static void generic(AccountService accountService) throws IOException {
        System.out.println("----------GENERIC----------");
        System.out.println(accountService.requestDepositAddress(Currency.BTC, new String[0]));
        System.out.println(accountService.getAccountInfo());
        System.out.println(accountService.withdrawFunds(Currency.BTC, new BigDecimal("0.03"), "XXX"));
        TradeHistoryParams params = accountService.createFundingHistoryParams();
        ((TradeHistoryParamsTimeSpan)params).setStartTime(new Date(System.currentTimeMillis() - 604800000L));
        List fundingHistory = accountService.getFundingHistory(params);
        for (FundingRecord fundingRecord : fundingHistory) {
            System.out.println(fundingRecord);
        }
    }

    private static void raw(PoloniexAccountServiceRaw accountService) throws IOException {
        System.out.println("------------RAW------------");
        System.out.println(accountService.getDepositAddress("BTC"));
        System.out.println(accountService.getWallets());
    }
}

