/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.poloniex.trade;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.examples.poloniex.PoloniexExamplesUtils;
import org.knowm.xchange.poloniex.PoloniexAdapters;
import org.knowm.xchange.poloniex.service.PoloniexTradeService;
import org.knowm.xchange.poloniex.service.PoloniexTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.utils.CertHelper;

public class PoloniexTradeDemo {
    private static final CurrencyPair REP_ETH = new CurrencyPair("REP", "ETH");
    private static CurrencyPair currencyPair;
    private static BigDecimal xmrBuyRate;

    public static void main(String[] args) throws Exception {
        CertHelper.trustAllCerts();
        Exchange poloniex = PoloniexExamplesUtils.getExchange();
        TradeService tradeService = poloniex.getTradeService();
        currencyPair = new CurrencyPair(Currency.XMR, Currency.BTC);
        xmrBuyRate = new BigDecimal("0.003");
        PoloniexTradeDemo.generic(tradeService);
        PoloniexTradeDemo.raw((PoloniexTradeServiceRaw)tradeService);
    }

    private static void generic(TradeService tradeService) throws Exception {
        System.out.println("----------GENERIC----------");
        PoloniexTradeService.PoloniexTradeHistoryParams params = new PoloniexTradeService.PoloniexTradeHistoryParams();
        params.setCurrencyPair(currencyPair);
        System.out.println(tradeService.getTradeHistory((TradeHistoryParams)params));
        params.setStartTime(new Date());
        System.out.println(tradeService.getTradeHistory((TradeHistoryParams)params));
        Calendar endTime = Calendar.getInstance();
        endTime.add(10, 4);
        params.setEndTime(endTime.getTime());
        System.out.println(tradeService.getTradeHistory((TradeHistoryParams)params));
        LimitOrder order = new LimitOrder.Builder(Order.OrderType.BID, currencyPair).originalAmount(new BigDecimal(".1")).limitPrice(xmrBuyRate).build();
        String orderId = tradeService.placeLimitOrder(order);
        System.out.println("Placed order #" + orderId);
        PoloniexTradeDemo.printOpenOrders(tradeService);
        boolean canceled = tradeService.cancelOrder(orderId);
        if (canceled) {
            System.out.println("Successfully canceled order #" + orderId);
        } else {
            System.out.println("Did not successfully cancel order #" + orderId);
        }
        PoloniexTradeDemo.printOpenOrders(tradeService);
    }

    private static void raw(PoloniexTradeServiceRaw tradeService) throws IOException, InterruptedException {
        System.out.println("------------RAW------------");
        System.out.println(Arrays.asList(tradeService.returnTradeHistory(currencyPair, null, null)));
        long startTime = new Date().getTime() / 1000L - 28800L;
        System.out.println(Arrays.asList(tradeService.returnTradeHistory(currencyPair, Long.valueOf(startTime), null)));
        long endTime = new Date().getTime() / 1000L;
        System.out.println(Arrays.asList(tradeService.returnTradeHistory(currencyPair, Long.valueOf(startTime), Long.valueOf(endTime))));
        LimitOrder order = new LimitOrder.Builder(Order.OrderType.BID, currencyPair).originalAmount(new BigDecimal("1")).limitPrice(xmrBuyRate).build();
        String orderId = tradeService.buy(order).getOrderNumber().toString();
        System.out.println("Placed order #" + orderId);
        Thread.sleep(3000L);
        System.out.println(PoloniexAdapters.adaptPoloniexOpenOrders((Map)tradeService.returnOpenOrders()));
        boolean canceled = tradeService.cancel(orderId);
        if (canceled) {
            System.out.println("Successfully canceled order #" + orderId);
        } else {
            System.out.println("Did not successfully cancel order #" + orderId);
        }
        Thread.sleep(3000L);
        System.out.println(PoloniexAdapters.adaptPoloniexOpenOrders((Map)tradeService.returnOpenOrders()));
    }

    private static void printOpenOrders(TradeService tradeService) throws Exception {
        TimeUnit.SECONDS.sleep(2L);
        OpenOrdersParamCurrencyPair params = (OpenOrdersParamCurrencyPair)tradeService.createOpenOrdersParams();
        OpenOrders openOrders = tradeService.getOpenOrders((OpenOrdersParams)params);
        System.out.printf("All open Orders: %s%n", openOrders);
        params.setCurrencyPair(currencyPair);
        openOrders = tradeService.getOpenOrders((OpenOrdersParams)params);
        System.out.printf("Open Orders for %s: %s%n: ", params, openOrders);
        params.setCurrencyPair(REP_ETH);
        openOrders = tradeService.getOpenOrders((OpenOrdersParams)params);
        System.out.printf("Open Orders for %s: %s%n: ", params, openOrders);
    }
}

