/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.quoine.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.quoine.QuoineExchange;
import org.knowm.xchange.quoine.dto.marketdata.QuoineOrderBook;
import org.knowm.xchange.quoine.service.QuoineMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class OrderBookDemo {
    public static void main(String[] args) throws IOException {
        Exchange quoineExchange = ExchangeFactory.INSTANCE.createExchange(QuoineExchange.class.getName());
        OrderBookDemo.generic(quoineExchange);
        OrderBookDemo.raw(quoineExchange);
    }

    private static void generic(Exchange quoineExchange) throws IOException {
        MarketDataService quoineMarketDataService = quoineExchange.getMarketDataService();
        OrderBook orderBook = quoineMarketDataService.getOrderBook(CurrencyPair.BTC_USD, new Object[0]);
        System.out.println(orderBook.toString());
        System.out.println("full orderbook size: " + (orderBook.getAsks().size() + orderBook.getBids().size()));
    }

    private static void raw(Exchange quoineExchange) throws IOException {
        QuoineMarketDataServiceRaw quoineMarketDataService = (QuoineMarketDataServiceRaw)quoineExchange.getMarketDataService();
        QuoineOrderBook quoineOrderBook = quoineMarketDataService.getOrderBook(1);
        System.out.println(quoineOrderBook.toString());
        System.out.println("size: " + (quoineOrderBook.getSellPriceLevels().size() + quoineOrderBook.getBuyPriceLevels().size()));
    }
}

