/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.examples.ripple.marketdata;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeFactory;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.ripple.RippleExchange;
import org.knowm.xchange.ripple.dto.marketdata.RippleOrderBook;
import org.knowm.xchange.ripple.service.RippleMarketDataServiceRaw;
import org.knowm.xchange.ripple.service.params.RippleMarketDataParams;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class RippleOrderBookDemo {
    public static void main(String[] args) throws IOException {
        Exchange ripple = ExchangeFactory.INSTANCE.createExchange(RippleExchange.class.getName());
        MarketDataService marketDataService = ripple.getMarketDataService();
        RippleOrderBookDemo.raw((RippleMarketDataServiceRaw)marketDataService);
        RippleOrderBookDemo.generic(marketDataService);
    }

    private static void generic(MarketDataService marketDataService) throws IOException {
        RippleMarketDataParams params = new RippleMarketDataParams();
        params.setAddress("rvYAfWj5gh67oV6fW32ZzP3Aw4Eubs59B");
        params.setBaseCounterparty("rvYAfWj5gh67oV6fW32ZzP3Aw4Eubs59B");
        params.setLimit(10);
        OrderBook orderBook = marketDataService.getOrderBook(CurrencyPair.BTC_XRP, new Object[]{params});
        System.out.println(orderBook.toString());
    }

    private static void raw(RippleMarketDataServiceRaw marketDataService) throws IOException {
        RippleMarketDataParams params = new RippleMarketDataParams();
        params.setAddress("rMwjYedjc7qqtKYVLiAccJSmCwih4LnE2q");
        params.setBaseCounterparty("rMwjYedjc7qqtKYVLiAccJSmCwih4LnE2q");
        params.setCounterCounterparty("rMwjYedjc7qqtKYVLiAccJSmCwih4LnE2q");
        params.setLimit(10);
        RippleOrderBook orderBook = marketDataService.getRippleOrderBook(CurrencyPair.EUR_USD, params);
        System.out.println(orderBook.toString());
    }
}

